#!/bin/sh
#
# =============================================================================
#  COPYRIGHT (c) 2015-2017 - IRT SystemX
# =============================================================================
#
#  Project: "OpenAltaRica"
#
# =============================================================================
#  All rights reserved.
# =============================================================================
#

echo "change current directory to compiler folder ($1)"

cd $1
if test ! -d ./gtssto/lib; then
    cd $1/gtssto
    if [ ! -f ./bld.sh ]; then
        echo "ERROR: your installation is corrupted.(err:cmp:19)"
        echo "       The OpenAltaRica platform needs to be reinstalled!"
        exit 1
    fi
    bash ./bld.sh
	local_rc=$?
    if [ ! ${local_rc} -eq 0 ]; then
        echo "ERROR: your installation is corrupted.(err:cmp:26)"
        echo "       The OpenAltaRica platform needs to be reinstalled!"
        exit 1
    fi
    if [ ! -f ./lib/libgtsstokernel.a ]; then
        echo "ERROR: your installation is corrupted.(err:cmp:31)"
        echo "       The OpenAltaRica platform needs to be reinstalled!"
        exit 1
    fi
    rm -f ./bld.sh
    cd $1
fi

cd $1

if [ ! -f ./gtssto/lib/libgtsstokernel.a ]; then
    echo "ERROR: your installation is corrupted.(err:cmp:41)"
    echo "       The OpenAltaRica platform needs to be reinstalled!"
    exit 1
fi

echo "clean up compiler folders"
if [ -f ./gtssto/obj/main.o ]; then
    rm -f gtssto/obj/*.o
fi
rm -f gtssto/bin/*
if [ -f ./gtssto/src/STOModel.cpp ]; then
    rm -f ./gtssto/src/STOModel.cpp
fi
if [ -f ./gtssto/include/STOModel.hpp ]; then
    rm -f ./gtssto/include/STOModel.hpp
fi

echo "generate C++ files"
./gtsstocmp --Optimize assertion --configuration $3 --output gtssto/tmp $2
mv ./gtssto/tmp/STOModel.cpp ./gtssto/src
mv ./gtssto/tmp/STOModel.hpp ./gtssto/include

echo "compile C++ files"
g++ -w -I ./gtssto/include -std=c++11 -std=gnu++11  -D __MODE_TRACE__ -O2 -s -c -o ./gtssto/obj/STOModel.o ./gtssto/src/STOModel.cpp
g++ -w -I ./gtssto/include -std=c++11 -std=gnu++11  -D __MODE_TRACE__ -O2 -s -c -o ./gtssto/obj/main.o ./gtssto/src/main.cpp
g++ -w -L ./gtssto/lib -std=c++11 -std=gnu++11 -o ./gtssto/bin/gtssto.bin ./gtssto/obj/STOModel.o ./gtssto/obj/main.o -lm -l gtsstokernel

echo "copy binary to the target directory"
mv ./gtssto/bin/gtssto.bin $4

echo compilation completed
